# Structure - Multi-agent architecture within Dell
### Intro
Outcome agents define user intent based on higher level prompt or user's current session
Outcome agent invokes domain agent, Transact agent. 

### Transact agent structure: 
- MCP server with specialist transact "brain". 
	- This decides which tools to be used and in what sequence (orchestration). 
	- Has access to transact tools catalog
	- Has understanding of tools chain to be executed as series of steps for a given prompt
- Tool catalog and tool chain
	- Tool catalog contains grouping of tools to be used within transact agent. 
	- Tool chain can be decided by transact agent. E.g. 
		- For checkout chain (scope is too big and high level, needs to be narrowed further)
			- **Tool 1: `get_user_default_address`** (Retrieves data).
			- **Tool 2: `validate_inventory`** (Ensures items are still there).
		    - **Tool 3: `calculate_totals`** (Calculates tax/shipping via a 3rd party API like TaxJar or Avalara).
			- **Response:** The Transact Agent bundles this and tells the user: _"I've set this to ship to your Austin address. Total with tax is $1,240. Ready to place the order?"_
		- For pricing chain (simple use case of applying coupon code)
			- **Tool 1**`apply_coupon`, 
			- **Tool 2** `get_bulk_discount`, 
			- **Tool 3** `calculate_tax`
	- Tool chain approach gives benefits around observability, resiliency and security. 

# Transact Brain
### Approach: 
- **Analyze State:** What do I already know? (e.g., _Cart has item X, but address is missing._)
- **Determine Goal:** What is the next required step for a "Submit Order" outcome?
- **Select Tool(s):** Which MCP tools will get me closer to that goal?
- **Execute & Validate:** Run the tool and check if it succeeded.

### Elements of transact brain
##### State map
Configuration file that defines required fields for each step in the journey
##### Instruction set 
System prompt that defines set of instructions to be followed by the agent, and how agent should handle the tools and the user 
##### Context store 
Agent reads this at the start of every interaction and updates it based on the steps taken

### References 
Kean Nam - Agentic strategy confluence
Check with Ted on what scope is doable in Q2 under One Quote
